/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef DNS_PACKET_H
#define DNS_PACKET_H

#include <libpandora/global.h>

extern "C" {
#include <netinet/in.h>
#include <arpa/nameser.h>
#include <resolv.h>
}

#include <libpandora/packet.h>
#include <libpandora/array.h>
#include <libpandora/serialize.h>
#include <pandora_components/rrec.h>

class UDPPacket;

struct dns_query_t {
  char name[MAXDNAME+1];
  u_short type;
  u_short _class;
};



class DNSPacket : public Packet {
public:
  enum dns_t {undefined = -1, request, response }; 

public:
  dns_t			type;
  u_short  		id;
  u_char  		opcode;
  u_char  		aa;
  u_char  		tc;
  u_char  		rd;
  u_char  		ra;
  u_char 		rcode;
  u_short  		length;
  Array<dns_query_t>	qd;
  Array<rrecord_t> 	an;
  Array<rrecord_t> 	ns;
  Array<rrecord_t> 	ar;

private:
  u_char	*bom, *eom;

public:
  packet_init(DNSPacket, 1);

  DNSPacket(UDPPacket *);
  DNSPacket(const DNSPacket& x);
  DNSPacket& operator= (const DNSPacket& x);
  virtual ~DNSPacket(void) {}

  bool isQuery(void) const { return (type == request); }

  bool reject(void) const { return (type < 0); }
  virtual void print(ostream *);
  void printRR(ostream *, const rrecord_t &);
  
  virtual size_t write(char *, size_t, int) ;
  virtual size_t read(const char *, int);

private:
  int expN(char *buf, const char *cp, u_short len) {
    return dn_expand((u_char *)cp, (u_char *)cp+len,
                     (u_char *)cp, buf, MAXDNAME);
  }
  int expandName(char *, u_char *);
  int parseQuery(dns_query_t *, UDPPacket *);
  int parseRRecord(rrecord_t *, UDPPacket *);
};

serialEnum(DNSPacket::dns_t);

extern void serialize(char *, size_t &, const size_t, dns_query_t*);
extern void unserialize(const char *, size_t &,  dns_query_t*);

extern void serialize(char *, size_t &, const size_t, rrecord_t*);
extern void unserialize(const char *, size_t &,  rrecord_t*);

#endif /* DNS_PACKET_H */
