/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef FAMINPUT_COMPONENT_H
#define FAMINPUT_COMPONENT_H

#include <libpandora/global.h>

#include <libpandora/inputcomponent.h>
#include <libpandora/demap.h>
#include <libpandora/pipe.h>
#include <libpandora/text.h>
#include <fam.h>

class FAMInputComponent : public InputComponent { 
private:
  class request_t {
  private:
    static int	 	count;

  public:
    int			id;
    text 		filename;

    request_t(const text &t) : id(++count), filename(t) { }
  };

  bool			doStop;
  Pipe<request_t *>	toMonitor;
  DEMap<int, text>	monitored_dirs;
  FAMConnection 	fc;
  char 			path_buf[PATH_MAX];
  char 			*initialdir;
  bool			block;

public:
  component_init(FAMInputComponent, 1);
  FAMInputComponent(void);
  virtual ~FAMInputComponent(void) { }

  virtual int  init(void);
  virtual bool process(void);
  virtual void finish(void);
  virtual void halt(void);
  virtual bool add(Packet *);

private:
  int  monitor(const request_t &req);
  bool cancel(int req);
  bool handle(FAMEvent *fe);
  void log(FAMEvent *fe);
  bool getFileName(FAMEvent *fe, text &);
  int  getDirName(text &);
};

#endif /* FAMINPUT_COMPONENT_H */
