/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef FDPIPE_INPUT_COMPONENT_H
#define FDPIPE_INPUT_COMPONENT_H

#include <libpandora/global.h>

#include <libpandora/inputcomponent.h>
#include <libpandora/pandora_limits.h>
#include <libpandora/thread.h>

class Packet;

class FdPipeInputComponent : public InputComponent {
private:
  Mutex mx;
  char wbuf[MAX_PACKET_SIZE], rbuf[MAX_PACKET_SIZE];
  int fdpipe[2];
  FILE *fin, *fout;
  bool doStop;

public:
  component_init(FdPipeInputComponent, 1);
  inline  FdPipeInputComponent(void);
  virtual ~FdPipeInputComponent(void) { }

  virtual bool add(Packet *);  

  virtual int  init(void);
  virtual bool process(void);  
  virtual void finish(void);
  virtual void halt(void);
};

FdPipeInputComponent::FdPipeInputComponent(void) 
  : fin(NULL), fout(NULL), doStop(false) 
{ 
}

#endif /* FDPIPE_INPUT_COMPONENT_H */
