/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef FILE_TO_URL_COMPONENT_H
#define FILE_TO_URL_COMPONENT_H

#include <libpandora/global.h>

extern "C" {
#ifdef HAVE_PCRE_H
#include <pcre.h>
#else 
#error file <pcre.h> needed to build this component
#endif
	   }

#include <libpandora/component.h>
#include <libpandora/set.h>

class FSEventPacket;

class FileToURLComponent : public Component {
private:
  class pcre_repl_t {
  private:
    const static int max_subs = 32;
    const static int vec_size = 3 * (max_subs + 1);
    int sub_repl[vec_size];
    int nsubs;

    pcre *pattern;

    char *repl;
    int repl_len;

  public:
    pcre_repl_t(const char *, const char *);
    ~pcre_repl_t(void);

    bool match(const char *, int, char *, int);
    bool isSet(void) { return (pattern != NULL); }

  private:
    void repl_compile(void);
  };

  const static int max_rules = 256;
  char buffer[BUFSIZ];
  char *name;
  pcre_repl_t *mappings[max_rules];
  int nrules;

public:
  component_init(FileToURLComponent, 1);
  FileToURLComponent(void);
  virtual ~FileToURLComponent(void) { }

  virtual bool add(Packet *);
  virtual void setup(void);
  virtual void cleanup(void);

private:
};

#endif /* FILE_TO_URL_COMPONENT_H */
