/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef FSEVENT_PACKET_H
#define FSEVENT_PACKET_H

#include <libpandora/global.h>

extern "C" {
#include <limits.h>
	   }

#include <libpandora/packet.h>
#include <libpandora/text.h>
#include <libpandora/serialize.h>


class SyscallPacket;
class TextValuePacket;

class FSEventPacket : public Packet {
private:
  char path_buf[PATH_MAX];

public:
  enum fseventt_t { UNDEF = -1, CREATED, ACCESSED, DELETED, MODIFIED };

  fseventt_t	type;
  bool		success;
  text		path;

public:
  packet_init(FSEventPacket, 1);

public:
  FSEventPacket(SyscallPacket *);
  FSEventPacket(TextValuePacket *);
  FSEventPacket(char *, fseventt_t t = UNDEF);
  FSEventPacket(const FSEventPacket& x);
  FSEventPacket& operator= (const FSEventPacket& x);
  virtual ~FSEventPacket(void) { }

  virtual void print(ostream *f) ;

  virtual size_t write(char *, size_t, int) ;
  virtual size_t read(const char *, int);
  
  inline void setType(fseventt_t);
  inline void failed(void);
  inline bool pathSet(void) 		{ return !path.isNull(); }
  void update(SyscallPacket *sp);

private:
  void init(char *);
  void setPath(text *p, const char *cwd, const char *pwd);
  void pathCanonicalize(text *_path, char *);
};

serialEnum(FSEventPacket::fseventt_t);

inline void FSEventPacket::setType(fseventt_t t)
{
  if (type < t) type = t;
}

inline void FSEventPacket::failed(void)
{
  success = false;
}

#endif /* FSEVENT_PACKET_H */
