/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef FSEVENT_SCAN_COMPONENT_H
#define FSEVENT_SCAN_COMPONENT_H

#include <libpandora/global.h>

#include <libpandora/component.h>
#include <pandora_components/fseventpacket.h>
#include <pandora_components/ippacket.h>

class FSEventPacket;

class FSEventScanComponent : public Component {
private:
  FSEventPacket *fsep;

public:
  component_init(FSEventScanComponent, 1);
  FSEventScanComponent(void) : fsep(NULL) {}
  virtual ~FSEventScanComponent(void) {}

  virtual bool add(Packet *p);
  virtual void cleanup(void);

private:
  inline void dispatch(void);
};

void FSEventScanComponent::dispatch(void)
{
  if (fsep != NULL) {
    if (fsep->pathSet()) {
      push(fsep);
      fsep = NULL;
    } else {
      cleanPacket(fsep);
    }
  }
}

#endif /* FSEVENT_SCAN_COMPONENT_H */
