/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#include <libpandora/global.h>

#include "genericcomponent.h" 
#include <libpandora/common_options.h>

component_export(GenericComponent, Packet, Packet);


GenericComponent::GenericComponent(void)
  : add_func(NULL), setup_func(NULL), cleanup_func(NULL),
    iop0(0), iop1(-1), bop0(false), bop1(true),
    fop0(0.0), fop1(1.0), sop0(NULL), sop1(NULL)
{ 
  registerComplexOption(symbol_option, "add", 		&add_func);  
  registerComplexOption(symbol_option, "setup", 	&setup_func);  
  registerComplexOption(symbol_option, "cleanup", 	&cleanup_func);  

  registerOption("int0",	&iop0);
  registerOption("int1",	&iop1);
  registerOption("bool0",	&bop0);
  registerOption("bool1",	&bop1);
  registerOption("float0",	&fop0);
  registerOption("float1",	&fop1);
  registerOption("string0",	&sop0);
  registerOption("string1",	&sop1);
}

bool GenericComponent::add(Packet *pkt) 
{
  if (add_func == NULL) {
    push(pkt);
    return false;
  }
  
  return !(*add_func)(pkt, this);
} 

void GenericComponent::setup(void) 
{
  if (setup_func != NULL) (*setup_func)(this);
}

void GenericComponent::cleanup(void) 
{
  if (cleanup_func != NULL) (*cleanup_func)(this);
}


