/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef GENERIC_COMPONENT_H
#define GENERIC_COMPONENT_H

#include <libpandora/global.h>

#include <libpandora/component.h>

class Packet;

class GenericComponent : public Component { 
private: 
  typedef bool (*action_t)(Packet *, Component *);
  typedef void (*setup_t)(Component *);
  action_t 	add_func;
  setup_t	setup_func, cleanup_func; 
  int		iop0,  iop1;
  bool		bop0,  bop1;
  float		fop0,  fop1;
  char		*sop0, *sop1;

public:
  component_init(GenericComponent, 1);
  GenericComponent(void);
  virtual ~GenericComponent(void) { }

  virtual bool add(Packet *p); 
  virtual void setup(void);
  virtual void cleanup(void);
};

#endif /* GENERIC_COMPONENT_H */

