/* ANSI-C code produced by gperf version 2.7.2 */
/* Command-line: gperf -o -7 -t -L ANSI-C header_action.dat  */
struct header_action {
       const char *name;
       void (*action)(HTTPScanComponent *, void *, const char *);
       void *var;
};

#define TOTAL_KEYWORDS 17
#define MIN_WORD_LENGTH 3
#define MAX_WORD_LENGTH 19
#define MIN_HASH_VALUE 3
#define MAX_HASH_VALUE 24
/* maximum key range = 22, duplicates = 0 */

#ifdef __GNUC__

#else
#ifdef __cplusplus

#endif
#endif
static unsigned int
hash (register const char *str, register unsigned int len)
{
  static unsigned char asso_values[] =
    {
      25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
      25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
      25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
      25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
      25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
      25, 25, 25, 25, 25, 25, 25, 25, 25, 25,
      25, 25, 25, 25, 25, 25, 25,  0, 20, 15,
      25, 25,  0,  0, 25, 25,  5, 25, 25, 25,
       5, 25,  0,  5, 25,  0,  0, 25,  0, 25,
      25, 25, 25, 25, 25, 25, 25,  0, 25, 25,
       0,  0, 25,  0,  0, 25, 25, 25,  0, 25,
      25, 25, 25, 25,  0,  0,  0, 25, 25, 25,
      25, 25, 25, 25, 25, 25, 25, 25
    };
  return len + asso_values[str[len - 1]] + asso_values[str[0]];
}

#ifdef __GNUC__

#endif
struct header_action *
in_word_set (register const char *str, register unsigned int len)
{
  static struct header_action wordlist[] =
    {
      {""}, {""}, {""},
      {"Via", &get_inc, (void *) &HTTPPacket::via},
      {"Host", &get_text, (void *) &HTTPPacket::host},
      {""},
      {"Cookie", &get_text, (void *) &HTTPPacket::cookie},
      {"Referer", &get_text, (void *) &HTTPPacket::ref},
      {""},
      {"X-Pandora", &get_integer, (void *) &HTTPPacket::coll},
      {"User-Agent", &get_text, (void *) &HTTPPacket::useragent},
      {"Pragma", &get_pragma, (void *) &HTTPPacket::pragma},
      {"Content-Type", &get_mime, (void *) &HTTPPacket::ct},
      {"Cache-Control", &get_cctrl, (void *) &HTTPPacket::cctrl},
      {"Content-Length", &get_integer, (void *) &HTTPPacket::cl},
      {"Set-Cookie", &get_inc, (void *) &HTTPPacket::cookies},
      {"Content-Encoding", &get_enc, (void *) &HTTPPacket::ce},
      {"If-Modified-Since", &get_date, (void *) &HTTPPacket::ims},
      {"Last-Modified", &get_date, (void *) &HTTPPacket::lm},
      {"If-Unmodified-Since", &get_date, (void *) &HTTPPacket::ius},
      {""}, {""},
      {"Expires", &get_date, (void *) &HTTPPacket::expires},
      {""},
      {"Date", &get_date, (void *) &HTTPPacket::date}
    };

  if (len <= MAX_WORD_LENGTH && len >= MIN_WORD_LENGTH)
    {
      register int key = hash (str, len);

      if (key <= MAX_HASH_VALUE && key >= 0)
        {
          register const char *s = wordlist[key].name;

          if (*str == *s && !strcmp (str + 1, s + 1))
            return &wordlist[key];
        }
    }
  return 0;
}
