/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

%{
#include <libpandora/global.h>

extern "C" {
#include <stdlib.h>
#include <libpandora/conf/string.h>
#include <libpandora/conf/time.h>
#include <ctype.h>
}

#if (defined linux) && !(defined __FAVOR_BSD)
#define __FAVOR_BSD
#endif

#include <pandora_components/httppacket.h>
#include <libpandora/http_date.h>
#include <libpandora/encoding.h>

#include "httpscancomponent.h"

#define YY_NO_UNPUT
#define YY_DECL int yylex(HTTPScanComponent *c)

extern YY_DECL;

#define YY_USER_ACTION	c->data += yyleng;

char *extract_content(int offset, char *txt, int len)
{
  char *start = txt+offset, *stop = txt+len-1;
  while (isspace(*start)) ++start;
  while (isspace(*stop))  --stop;
  stop[1] = '\0';
  return start;
}

#define EXTRACT(n)	extract_content((n), yytext, yyleng)
%}
%option 8bit
%option noreject
%option noyymore
%option noyywrap

content		[^\n]*\n	
%%

Host:{content}			c->msg->host.init(EXTRACT(5));
Date:{content}			c->msg->date=http_date_to_time(EXTRACT(5));
Content-Length:{content}	c->msg->cl=atoi(EXTRACT(15));
Content-Type:{content}		if (c->MIME != NULL) c->msg->ct=c->MIME->encode(EXTRACT(13));
Content-Encoding:{content}	if (c->ENC != NULL) c->msg->ce=c->ENC->encode(EXTRACT(17));
Referer:{content}		c->msg->ref.init(EXTRACT(8));
Pragma:{content}		c->msg->pragma=(strcasecmp(EXTRACT(7),"no-cache")==0 ? HTTPPacket::no_cache : HTTPPacket::unset);
If-Modified-Since:{content}	c->msg->ims=http_date_to_time(EXTRACT(18));
Last-Modified:{content}		c->msg->lm=http_date_to_time(EXTRACT(14));
Expires:{content}		c->msg->expires=http_date_to_time(EXTRACT(8));
Set-Cookie:{content}		++c->msg->cookies;
Cookie:{content}		c->msg->cookie.init(EXTRACT(7));
User-Agent:{content}		c->msg->useragent.init(EXTRACT(11));
Cache-Control:{content} 	c->msg->cctrl.parse(EXTRACT(14));
If-Unmodified-Since:{content}	c->msg->ius=http_date_to_time(EXTRACT(20));
Via:{content}			++c->msg->via;
X-Pandora:{content}		c->msg->coll=atoi(EXTRACT(10));
[a-zA-Z0-9\-]+:{content}	;

\r?\n		return 1;
.*\n?		{ if (c->data == c->tcpp->length) { c->unmatched = c->data - yyleng; return 0; } } 

<<EOF>>		return 0;

%%
void init_header_buffer(char *str, int len)
{
#if 0
  yy_switch_to_buffer(yy_scan_bytes(str, len));
#else
  //pandora_debug("scan length: " << len);
  YY_BUFFER_STATE buf = yy_scan_buffer(str, len+2);
  pandora_assert(buf != 0);
  yy_switch_to_buffer(buf);
#endif
}        

void release_header_buffer(void)
{
  yy_delete_buffer(YY_CURRENT_BUFFER);
}

#undef EXTRACT
