/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef HTTP_LOGGER_COMPONENT_H
#define HTTP_LOGGER_COMPONENT_H

#include <libpandora/global.h>

#include <iostream>
#include <libpandora/packet.h>
#include <libpandora/outputcomponent.h>
#include <libpandora/common_options.h>

class HTTPLoggerComponent : public OutputComponent {
private:
  ostream *matches, *reqs, *resps;
  char timefmt[64];

public:
  component_init(HTTPLoggerComponent, 1);
  inline  HTTPLoggerComponent(void);
  virtual ~HTTPLoggerComponent(void) { }

  virtual bool add(Packet *);
  virtual void setup(void);

private:
  void print_date(ostream *, time_t);
};

  HTTPLoggerComponent::HTTPLoggerComponent(void) 
    : matches(&cout), reqs(&cerr), resps(&cerr) 
{
  registerStaticOption(ofstream_option, "log", &matches);
  registerStaticOption(ofstream_option, "reqs", &reqs);
  registerStaticOption(ofstream_option, "resps", &resps);
}

#endif /* HTTP_LOGGER_COMPONENT_H */
