/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef HTTP_MATCH_COMPONENT_H
#define HTTP_MATCH_COMPONENT_H

#include <libpandora/global.h>

#include <list>

#include <libpandora/component.h>
#include <pandora_components/httppacket.h>

class HTTPTransPacket;

class HTTPMatchComponent : public Component {
private:
  typedef list<HTTPPacket*> list_t;
  typedef list_t::iterator  list_ptr_t;

  list_t	reqlist[2];
  bool		strict;

public:
  component_init(HTTPMatchComponent, 1);
  inline  HTTPMatchComponent(void);
  virtual ~HTTPMatchComponent(void) { }

  bool add(Packet*);

  virtual void cleanup(void);
  
private:
  void unmatched(HTTPPacket *);
  void flush(list_t *);
  bool check(HTTPPacket *, HTTPPacket *, bool);
};

HTTPMatchComponent::HTTPMatchComponent(void) 
  : strict(true) 
{
  registerOption("strict", &strict);
}

#endif /* HTTP_MATCH_COMPONENT_H */
