/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef HTTP_PACKET_H
#define HTTP_PACKET_H

#include <libpandora/global.h>

#include <libpandora/packet.h>
#include <libpandora/serialize.h>
#include <pandora_components/cctrl.h>

class TCPPacket;
class TextValuePacket;


class HTTPPacket : public Packet {
public:
  enum http_t 		{ unknown = -1, request, response, value  };
  enum http_method_t 	{ UNDEF = -1, GET, POST, HEAD, PUT, 
			  OPTIONS, TRACE, DELETE };
  enum http_pragma_t 	{ unset = -1, no_cache };

public:
  http_t 	type;
  http_method_t	method;
  int 		code;
  u_int32_t 	beg;
  u_int32_t 	endh;
  u_int32_t 	endm;
  timeval 	last;

  int 		version;
  time_t 	date;
  int 		ce;
  int 		ct;
  int 		cl;
  http_pragma_t	pragma;
  time_t 	ims;
  time_t 	ius;
  time_t 	lm;
  time_t 	expires;
  short 	cookies;
  short		via;
  text 		url;
  text		ref;
  text 		host;
  text 		useragent;
  text		cookie;
  int 		coll;
  cctrl_t 	cctrl;

  bool		dynamic;
  bool		hashed; 
  bool		absolute;
  bool 		cacheable;
  bool 		gap;
  bool 		eof;

  bool 		hdrOK;
  int 		etag, im, inm;

public:
  packet_init(HTTPPacket, 1);

  HTTPPacket(TCPPacket *tcpp);
  HTTPPacket(TextValuePacket *);
  HTTPPacket(const HTTPPacket& x) ;
  HTTPPacket& operator= (const HTTPPacket& x);
  virtual ~HTTPPacket(void) { }

  virtual void print(ostream *) ;

  virtual size_t write(char *, size_t, int) ;
  virtual size_t read(const char *, int);

  void urlCanonicalize(void);
  bool reject(void) const;
  void checkDynamicity(void);
};

serialEnum(HTTPPacket::http_t);
serialEnum(HTTPPacket::http_method_t);
serialEnum(HTTPPacket::http_pragma_t);


#endif /* HTTP_PACKET_H */
