/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <libpandora/global.h>

#include "httpsendercomponent.h"
#include <pandora_components/httppacket.h>
#include <pandora_components/ippacket.h>
#include <pandora_components/requestpacket.h>
#include <libpandora/common_options.h>
#include <libpandora/url.h>

component_export(HTTPSenderComponent, HTTPPacket+, RequestPacket);

HTTPSenderComponent::HTTPSenderComponent(void) 
  : proxy_port(0), proxy_addr(0), useProxy(false)
{
  registerOption("port", &proxy_port);
  registerComplexOption(inet_addr_option, "addr", &proxy_addr);
}

bool HTTPSenderComponent::add(Packet *pkt)
{
  locatePacket0(HTTPPacket, msg, pkt);
  //pandora_debug("Should fetch " << msg->url);

  char reqbuf[4192];

  URL url;
  
  if (msg == NULL || (msg->url).isNull()) goto finished;

  if (msg->method != HTTPPacket::GET && msg->method != HTTPPacket::HEAD) {
    //pandora_debug("Wrong method!");
    goto finished;
  }

  url.scan((msg->url).data());

  if (!url.isOK()) {
    pandora_warning("invalid URL: " << msg->url);
    goto finished;
  }

  url.escape();
  url.makeRequest(reqbuf, sizeof(reqbuf), "GET", useProxy);

  do {
    RequestPacket *rpp = NULL;
    if (useProxy) {
      rpp = new RequestPacket(proxy_addr, proxy_port, &msg->timeStamp);
    } else {
      in_addr_t addr = 0;
      locatePacket(IPPacket, ipp, msg);
      if (ipp != NULL && ipp->dst.s_addr != 0) {
	addr = ipp->dst.s_addr;
      } else {
	addr = url.getHostAddr();
      }
      if (addr == 0) goto finished;
      
      rpp = new RequestPacket(addr, url.getHostPort(), &msg->timeStamp);
    }
    pandora_assert(rpp != NULL);
    rpp->req.set(reqbuf, strlen(reqbuf));

    push(rpp);

  } while(0);

 finished:
  cleanPacket(pkt);

  return false;
}   

void HTTPSenderComponent::setup(void) 
{
  if (proxy_port > 0) {
    useProxy = true;
  }
}
