/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef ICP_PACKET_H
#define ICP_PACKET_H

#include <libpandora/global.h>

extern "C" {
#include <netinet/in.h>
#include <netinet/in_systm.h>
}

#include <libpandora/packet.h>
#include <libpandora/util.h>
#include <libpandora/text.h>

class UDPPacket;

struct icphdr {
  u_char	ih_opcode;
#define ICP_OP_INVALID		0
#define ICP_OP_QUERY		1
#define ICP_OP_HIT		2
#define ICP_OP_MISS		3
#define ICP_OP_ERR		4
#define ICP_OP_SECHO		10
#define ICP_OP_DECHO		11
#define ICP_OP_MISS_NOFETCH	21
#define ICP_OP_DENIED		22
#define ICP_OP_HIT_OBJ		23
  u_char	ih_v;
  u_short	ih_len;
  u_int32_t	ih_req;
  u_int32_t	ih_opt;
#define ICP_FLAG_HIT_OBJ	0x80000000
#define ICP_FLAG_SRC_RTT	0x40000000
  u_int32_t	ih_optdata;
  in_addr_t	ih_src;
};

#define ICP_IS_QUERY(x) (((x) == ICP_OP_QUERY) || ((x)/10 == ICP_OP_SECHO/10))

#define ICP_IS_RESPONSE(x) ((((x)/10 == ICP_OP_HIT/10) && (x)>ICP_OP_QUERY) \
			    || ((x)/10 == ICP_OP_MISS_NOFETCH/10))


class ICPPacket : public Packet {
public:
  u_char 	type;
#if 1
  u_short 	length;
#else 
  int		length
#endif
  u_int32_t  	flags;
  u_int32_t  	req;
  u_short  	mrtt;
  int  	 	size;
  in_addr_t  	client;
  text  	url;

public:
  packet_init(ICPPacket, 1);

  ICPPacket(UDPPacket *);
  ICPPacket(const ICPPacket& x);
  ICPPacket& operator= (const ICPPacket& x);
  virtual ~ICPPacket(void) { }

  bool isQuery(void) { return ICP_IS_QUERY(type); }

  virtual void print(ostream *) ;

  virtual size_t write(char *, size_t, int) ;
  virtual size_t read(const char *, int);
};

#endif /* ICP_PACKET_H */
