/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef ICP_TRANS_PACKET_H
#define ICP_TRANS_PACKET_H

#include <libpandora/global.h>

#include <libpandora/packet.h>
#include <libpandora/serialize.h>

class ICPPacket;


class ICPTransPacket : public Packet {
public:
  enum icpt_t { undefined = -1, request, response, match };

public:
  icpt_t	type;
  u_char 	rtype;
  int 		rtt;
  int 		length;

public:
  packet_init(ICPTransPacket, 1);

  ICPTransPacket(ICPPacket *q, ICPPacket *r);
  ICPTransPacket(ICPPacket *);
  ICPTransPacket(const ICPTransPacket& x);
  ICPTransPacket& operator= (const ICPTransPacket& x);
  virtual ~ICPTransPacket(void) { }

  virtual void print(ostream *f) ;

  virtual size_t write(char *, size_t, int) ;
  virtual size_t read(const char *, int);
};

serialEnum(ICPTransPacket::icpt_t);

#endif /* ICP_TRANS_PACKET_H */
