/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <libpandora/global.h>

#include "identitycomponent.h"
#include <libpandora/algo_funcs.h>
#include <libpandora/complex_option.h>
#include <libpandora/common_options.h>

component_export(NullComponent, Packet, Packet);
component_export(IdentityComponent, Packet, Packet);

#define ID_TRACE 2

class test_option : public complex_option {
  int i;

public:
  export_option(test_option);
  test_option(void) { pandora_info("test_option::test_option"); }
  ~test_option(void) { pandora_info("test_option::~test_option"); }
  bool set(const char *str) { i = atoi(str); return i; }
  void *getReference(void) { 
    cout << "-> " << i << " <-" << endl; 
    return (void *)i; 
  }
};

IdentityComponent::IdentityComponent(void) : 
  dtest(-23), ret(false), s(NULL)
{
  registerOption("return", &ret);
  registerOption("dtest", &dtest);
  registerStaticOption(test_option, "stest", &dtest);
  registerStaticOption(addr_set_option, "list", &s);

#if ID_TRACE
  pandora_info("IdentityComponent::IdentityComponent  [" << this 
	       << "] #" << rank << " (" << dtest << ")");
#endif
}

IdentityComponent::~IdentityComponent(void)
{
#if ID_TRACE
  pandora_info("IdentityComponent::~IdentityComponent [" << this 
	       << "] #" << rank << " (" << dtest << ")");
#endif
}

bool IdentityComponent::add(Packet *p) 
{ 
  //pandora_debug(timeout << ", " << p->timeStamp);
#if ID_TRACE > 1
  pandora_debug("IdentityComponent::add                [" << this 
		<< "] #" << rank << " (" << dtest << ")");
#endif
  push(p); 
  return ret;
}

void IdentityComponent::setup(void) 
{
#if ID_TRACE
  pandora_info("IdentityComponent::setup              [" << this 
	       << "] #" << rank << " (" << dtest << ")");
#endif
  if ((s != NULL) && (s->size() > 0)) {
    in_addr_t t;
    pandora_debug("address list option items:");
    elementsDo(*s, t) pandora_debug("  -> " << intoa(t));
  }
}

void IdentityComponent::cleanup(void) 
{
#if ID_TRACE
  pandora_info("IdentityComponent::cleanup            [" << this 
	       << "] #" << rank << " (" << dtest << ")");
#endif
}

void IdentityComponent::printme(const char *s, void *i)
{
  pandora_info(i << ' ' << s);
  *((char **)i) = "set";
}

bool IdentityComponent::query(const text &arg, MultiValue *mv)
{
  mv->set("hello world!");
  return true;
}

extern_pandora(setup, void, setupecho, (Component *context))
{
  cout << "[" << context << "] setup\n";
}

extern_pandora(setup, void, cleanupecho, (Component *context))
{
  cout << "[" << context << "] cleanup\n";
}

extern_pandora(action, void, addecho, (Packet *pkt, Component *context))
{
  cout << "[" << context << "] add " << pkt << "\n";
}
