/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef IP_PACKET_H
#define IP_PACKET_H

#include <libpandora/global.h>

extern "C" {
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <pandora_components/ip.h>
	   }

#include <libpandora/packet.h>
#include <libpandora/packetdata.h>


class IPPacket : public Packet {
public:
  in_addr 	src;
  in_addr 	dst;
  u_char  	ttl;
  int  	 	group;

  u_short  	length;
  u_int  	offset;
  int  	 	flags;
  u_char  	proto;
  u_short  	ident;
  u_int  	end;
  packetData  	_data;

public:
  packet_init(IPPacket, 1);

  inline IPPacket(const u_char *, u_int, const timeval &);
  IPPacket(int) 
    : group(-1), length(0), offset(0), flags(0), proto(0), end(0) { }
  IPPacket(const IPPacket& x);
  IPPacket& operator= (const IPPacket& x);
  virtual ~IPPacket(void) { }

  void init(const u_char *, u_int, const timeval &);
  
  virtual void print(ostream *) ;
  
  virtual size_t write(char *, size_t, int) ;
  virtual size_t read(const char *, int);

  inline  char  *data(void) 			{ return _data.getData(); }
  inline  size_t dlength(void) 			{ return _data.getLength(); }
};

IPPacket::IPPacket(const u_char *data, u_int len, const timeval &ts)
{
  init(data, len, ts);
}

#endif /* IP_PACKET_H */
