/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <libpandora/global.h>

#include <libpandora/algo_funcs.h>
#include <pandora_components/valuepacket.h>
#include "ipprotoswitchcomponent.h"

component_export(IPProtoSwitchComponent, IPPacket, IPPacket);

int IPProtoSwitchComponent::_switch(Packet *pkt) 
{
  IPPacket *ipp = static_cast<IPPacket *>(pkt);
  
  if ((ipp->_data).isEmpty()) {
    pandora_warning("invalid IP packet, skipping");
    return -1;
  }

  if (ipp->offset & 0x3fff) {
    //pandora_warning("fragmented packet, skipping");
    return -1;
  }

  switch(ipp->proto) {
  case IPPROTO_TCP:	if (processTCP >= 0)  return processTCP;  break;
  case IPPROTO_UDP:	if (processUDP >= 0) return processUDP;   break;
  case IPPROTO_ICMP:	if (processICMP >= 0) return processICMP; break;
  default:		break;
  }

  return -1;
}
