/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef IP_PROTO_SWITCH_COMPONENT_H
#define IP_PROTO_SWITCH_COMPONENT_H

#include <libpandora/global.h>

#include <libpandora/switchcomponent.h>
#include <pandora_components/ippacket.h>

/** IP protocol switch class.
    This switch component is used to forward IP packets according to their
    protocol (TCP, UDP, ICMP,...). It performs the extraction of the
    network protocol packet before pushing it.
 */
class IPProtoSwitchComponent : public SwitchComponent {
 private:
  int processTCP, processUDP, processICMP;

 public:

  component_init(IPProtoSwitchComponent, 1);
  IPProtoSwitchComponent(void) 
    : processTCP(-1), processUDP(-1), processICMP(-1) {
    registerOption("tcp", &processTCP);
    registerOption("udp", &processUDP);
    registerOption("icmp", &processICMP);
  }
  virtual ~IPProtoSwitchComponent(void) {}

  virtual int _switch(Packet *pkt) ;
};

#endif /* IP_PROTO_SWITCH_COMPONENT_H */
