/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef IP_REASS_COMPONENT_H
#define IP_REASS_COMPONENT_H

#include <libpandora/global.h>

#include <list>

#include <pandora_components/ippacket.h>
#include <libpandora/component.h>

class IPReassComponent : public Component {
protected:
  typedef list<IPPacket*> PList;
  typedef PList::iterator PListIter;

protected:  
  PList plist;
  int length;

public:

  component_init(IPReassComponent, 1);
  IPReassComponent(void) : length(0) { }
  virtual ~IPReassComponent(void) {}

  virtual bool add(Packet*);
  virtual void cleanup(void);

protected:
  void dispatch(void);
  bool done(void);
  inline void flush(void);
};


void IPReassComponent::flush(void) 
{
  if (!plist.empty()) {
    for (PListIter ptr=plist.begin(); ptr!=plist.end(); ++ptr) {
      IPPacket *ipp = *ptr;
      cleanPacket(ipp);
    }
    plist.clear();
  }
}


#endif /* IP_REASS_COMPONENT_H */
