/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <libpandora/global.h>

#include "iprewritercomponent.h" 
#include <pandora_components/ippacket.h> 
#include <libpandora/common_options.h>

component_export(IPRewriterComponent, IPPacket+, Packet);

IPRewriterComponent::IPRewriterComponent(void)
  : old_addr(0), new_addr(0)
{ 
  registerComplexOption(inet_addr_option, "old", &old_addr); 
  registerComplexOption(inet_addr_option, "new", &new_addr);  
}


bool IPRewriterComponent::add(Packet *pkt) 
{
  locatePacket0(IPPacket, ipp, pkt);

  if (ipp != NULL) {
    if ((ipp->src).s_addr == old_addr) (ipp->src).s_addr = new_addr;
    if ((ipp->dst).s_addr == old_addr) (ipp->dst).s_addr = new_addr;
  }

  push(pkt);
  return false;
} 
