/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef MEMBER_COMPONENT_H
#define MEMBER_COMPONENT_H

#include <libpandora/global.h>

#include <libpandora/inputcomponent.h>
#include <map>

class MemberComponent : public InputComponent {
private:
  static const u_int magic = 0x9a7d04a;
  int round;

  Map<in_addr_t, int> members;
  in_addr_t leader;
  int group;
  int wait;
  int timeout;

  int fd;
  sockaddr_in bcast_addr;
  
public:

  component_init(MemberComponent, 1);
  MemberComponent(void);
  virtual ~MemberComponent(void) { }

  virtual int  init(void);
  virtual bool process(void);
  virtual void finish(void);

private:
  int get_broadcast(int gr);
  
  bool do_poll(void);
  bool do_read(void);
  bool do_send(void);
  bool do_update(void);
};


#endif /* MEMBER_COMPONENT_H */
