/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef MULTI_PACKET_H
#define MULTI_PACKET_H

#include <libpandora/global.h>
#include <libpandora/array.h>
#include <libpandora/packet.h>

class MultiPacket : public Packet { 
private: 
  Array<Packet *>		elements;

public:
  packet_init(MultiPacket, 1);

  MultiPacket(int);
  MultiPacket(Packet *, Packet *);
  MultiPacket(const MultiPacket& x);
  MultiPacket& operator= (const MultiPacket& x);
  virtual ~MultiPacket(void);

  virtual void print(ostream *);

  virtual size_t write(char *, size_t, int) ;
  virtual size_t read(const char *, int);

  inline int 	size(void) 			{ return elements.size(); }
  inline Packet *get(int pos) 			{ return elements[pos]; }
  void 		store(Packet *pkt, int pos);
  void    	clear(void);
};

#endif /* MULTI_PACKET_H */
