/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <libpandora/global.h>

extern "C" {
#include <sys/socket.h>
}

#include <iostream>
#include "netreadercomponent.h"
#include <libpandora/server.h>
#include <libpandora/netutil.h>
#include <libpandora/pktutil.h>
#include <libpandora/packet.h>

component_export(NetReaderComponent,, Packet);

int NetReaderComponent::init(void)
{

  if (listen == 0) {
    pandora_warning("invalid port number " << listen);
    return ERROR_FILENO;
  }

  bool stream = (listen > 0);
  int fd = (stream ? listen : -listen);
  
  if (svr != NULL) delete svr;
  svr = new Server();
  if (!svr->init(&accept, (void *) this, fd, !usock, stream)) 
    return ERROR_FILENO;

  return svr->fileDesc();
}

bool NetReaderComponent::process(void)
{
  return svr->process();
}

void NetReaderComponent::finish(void)
{
  __DELETE(svr);
}


bool NetReaderComponent::read(int fd)
{
  Packet *pkt = NULL;
  packet_recv(pkt, fd, buf, MAX_PACKET_SIZE);
  if (pkt == NULL) return true;

  current_fd = fd;

  push(pkt);

  current_fd = -1;

  return false;
}

bool NetReaderComponent::pull(Packet *pkt)
{
#if 0
  pandora_debug("sending reply: " << *pkt);
#endif

  if (current_fd < 0) {
    pandora_warning("cannot send reply");
    return false;
  }

  int ret = packet_send(pkt, current_fd, buf, MAX_PACKET_SIZE);
  if (ret < 0) pandora_notice("connection lost");
  cleanPacket(pkt);
  
  return true;
}

bool NetReaderComponent::accept(int fd, void *udata) 
{
  NetReaderComponent *comp = (NetReaderComponent *)udata;
  pandora_assert(comp != NULL);

  return comp->read(fd);
}
