/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef NET_WRITER_COMPONENT_H
#define NET_WRITER_COMPONENT_H

#include <libpandora/global.h>

#include <libpandora/outputcomponent.h>
#include <libpandora/packet.h>
#include <libpandora/pandora_limits.h>

class NetWriterComponent : public OutputComponent {
private:
  char *host;
  int port;
  int fd;
  int wait;
  char buf[MAX_PACKET_SIZE];
  int max_retries;
  int retry_timeout;
  bool usock;

public:
  component_init(NetWriterComponent, 1);
  inline  NetWriterComponent(void);
  virtual ~NetWriterComponent(void) { }
  
  virtual bool add(Packet *m);
  virtual void setup(void);
  virtual void cleanup(void);

private:
  bool connect(void);
  bool isReadable(int);
  inline void cnx_close(void);
};

NetWriterComponent::NetWriterComponent(void) 
  : host(NULL), port(0), fd(-1), wait(0),
    max_retries(3), retry_timeout(2), usock(false)
{
  registerOption("wait", &wait);
  registerOption("host", &host);
  registerOption("port", &port);
  registerOption("retries", &max_retries);
  registerOption("retimeout", &retry_timeout);
  registerOption("unix", &usock);
}

inline void NetWriterComponent::cnx_close(void)
{
  if (fd > 0) {
    close(fd);
    fd = -1;
  }  
}

#endif /* NET_WRITER_COMPONENT_H */
