/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <libpandora/global.h>
#include <libpandora/stackdesc.h>

#include "pipeinputcomponent.h"

component_export(PipeInputComponent, Packet, Packet);

bool PipeInputComponent::add(Packet *pkt) 
{
  if (doStop) 	return_clean(pkt);
  compStack->usePacketType(pkt);
  olist.put(pkt);
  return false;
}

bool PipeInputComponent::process(void) 
{
  //pandora_debug("[pipe] waiting for packet");
  Packet *tmp = olist.get();

  if (tmp == NULL) return true;

  push(tmp);
  return false;
}

void PipeInputComponent::finish(void) 
{
  doStop = true;
  //pandora_debug("[flushing " << olist.size() << " queued packets]");
  empty();
}

void PipeInputComponent::halt(void)
{
  doStop = true;
  olist.put(NULL);
}

void PipeInputComponent::empty(void)
{
  while (isBusy()) {
    Packet *tmp = olist.get();
    cleanPacket(tmp);
  }
}
