/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef PIPE_INPUT_COMPONENT_H
#define PIPE_INPUT_COMPONENT_H

#include <libpandora/global.h>

extern "C" {
#include <libpandora/conf/unistd.h>
#include <assert.h>
	   }

#include <libpandora/inputcomponent.h>
#include <libpandora/pipe.h>

class Packet;

class PipeInputComponent : public InputComponent {
private:
  Pipe<Packet *> olist;
  bool doStop;

public:
  bool isBusy(void) { return !olist.isEmpty(); }

public:
  component_init(PipeInputComponent, 1);
  PipeInputComponent(void) : doStop(false) { }
  virtual ~PipeInputComponent(void) { empty(); }

  virtual bool add(Packet *);  

  virtual int  init(void)   { doStop = false; return THREADED_FILENO; }
  virtual bool process(void);  
  virtual void finish(void);
  virtual void halt(void);

  void empty(void);
};

#endif /* PIPE_INPUT_COMPONENT_H */
