/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#include <libpandora/global.h>

#include "portcomponent.h" 
#include "guile_pandora_proc.h"

component_export(PortComponent, Packet,);


PortComponent::PortComponent(void)
  : pipe_name(NULL), pkt_pipe(NULL)
{
  registerOption("name", &pipe_name);
}

bool PortComponent::add(Packet *pkt) 
{
  if (pkt_pipe == NULL || *pkt_pipe == NULL) {
    cleanPacket(pkt);
    return (pkt_pipe == NULL);
  }

  (*pkt_pipe)->put(pkt);
  return false;
} 

void PortComponent::setup(void)
{
  if (pipe_name != NULL) {
    packet_pipe_t *ppipe = 
      pandora_get_pipe_ptr(pandora_get_pipe(text(pipe_name)));
    if (ppipe == NULL) return;
    pkt_pipe = new (packet_pipe_t*);
    *pkt_pipe = ppipe;
  }
}

void PortComponent::cleanup(void) 
{
  __DELETE(pkt_pipe);
  pipe_name = NULL;
}


