/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <libpandora/global.h>

extern "C" {
#include <stdio.h>
}

#include <iostream>
#include "readercomponent.h"
#include <libpandora/packet.h>
#include <libpandora/pktutil.h>

component_export(ReaderComponent,, Packet);

int ReaderComponent::init(void)
{
  if ((name != NULL) 
      && ((f = fopen(name, "r")) == NULL)) {
    pandora_pwarning(name);
    return ERROR_FILENO;
  }

  return fileno(f);
}

bool ReaderComponent::process(void)
{
  if ((f == NULL) || (feof(f))) return true;

  Packet *pkt = NULL;
  packet_recv(pkt, f, buf, MAX_PACKET_SIZE);
  if (pkt == NULL) {
    //pandora_warning("read null packet");
    return true;
  }

  if (skip-- > 0) cleanPacket(pkt);
  else push(pkt);

  return false;
}

void ReaderComponent::finish(void)
{
  if ((f != NULL) && (f != stdin)){
    fclose(f);
    f = NULL;
  }
}
