/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef REORDER_COMPONENT_H
#define REORDER_COMPONENT_H

#include <libpandora/global.h>

extern "C" {
#include <libpandora/conf/time.h>
	   }

#include <queue>
#include <libpandora/component.h>
#include <libpandora/packet.h>
#include <libpandora/timeval.h>

struct pktlt {
public:
  bool operator()(const Packet *p1, const Packet *p2) const {
    return (p2->timeStamp < p1->timeStamp);
  }
};

class ReorderComponent : public Component {
private:
  priority_queue<Packet*, vector<Packet*>, pktlt> q;
  int qSize;
  timeval last;
  bool warn;

public:

  component_init(ReorderComponent, 1);
  inline ReorderComponent(void);
  virtual ~ReorderComponent(void) {}


  virtual bool add(Packet *pkt) ;
  virtual void cleanup(void) { while (!q.empty()) pop(); }
  
private:
  inline void pop(void);
};

ReorderComponent::ReorderComponent(void) : 
  qSize(1024), warn(false) 
{
    registerOption("size", &qSize);
    registerOption("warn", &warn);
    last.tv_sec = (time_t) 0;
    last.tv_usec = 0;
}

void ReorderComponent::pop(void) 
{
  Packet *pkt = q.top();
  if (pkt == NULL) return;
  q.pop();
  if (warn && (pkt->timeStamp < last)) 
    pandora_warning("Unordered record with time " << pkt->timeStamp);
  last = pkt->timeStamp;
  push(pkt);
}

#endif /* REORDER_COMPONENT_H */
