/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef RPC_PACKET_H
#define RPC_PACKET_H

#include <libpandora/global.h>

extern "C" {
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <rpc/rpc.h>
	   }

#include <libpandora/packet.h>
#include <libpandora/serialize.h>

class UDPPacket;


class RPCPacket : public Packet {
public:
  enum rpc_t { undefined = -1, request, response };

public:
  rpc_t 	type;
  u_int32_t 	xid;
  char 		status;
  bool 		accepted;
  u_int 	prog;
  u_int 	vers;
  u_int 	proc;
  u_short 	length;

public:
  packet_init(RPCPacket, 1);

  RPCPacket(UDPPacket *);
  RPCPacket(const RPCPacket& x);
  RPCPacket& operator= (const RPCPacket& x);
  virtual ~RPCPacket(void) { }

  bool isQuery(void) const { return (type == request); }
  virtual void print(ostream *) ;

  virtual size_t write(char *, size_t, int) ;
  virtual size_t read(const char *, int);
};

serialEnum(RPCPacket::rpc_t);

#endif /* RPC_PACKET_H */
