/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef RPC_TRANS_PACKET_H
#define RPC_TRANS_PACKET_H

#include <libpandora/global.h>

#include <libpandora/packet.h>
#include <libpandora/serialize.h>

class RPCPacket;


class RPCTransPacket : public Packet {
public:
  enum rpct_t { undefined = -1, request, response, match };

public:
  rpct_t	type;
  int 		rtt;
  int 		length;

public:
  packet_init(RPCTransPacket, 1);

  RPCTransPacket(RPCPacket *, RPCPacket *);
  RPCTransPacket(RPCPacket *);
  RPCTransPacket(const RPCTransPacket& x);
  RPCTransPacket& operator= (const RPCTransPacket& x);
  virtual ~RPCTransPacket() { }

  virtual void print(ostream *f) ;

  virtual size_t write(char *, size_t, int) ;
  virtual size_t read(const char *, int);
};

serialEnum(RPCTransPacket::rpct_t);

#endif /* RPC_TRANS_PACKET_H */
