/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <libpandora/global.h>

extern "C" {
#include <libpandora/conf/usleep.h>
	   }

#include "shapercomponent.h"
#include <libpandora/util.h>

component_export(ShaperComponent, Packet, Packet);

bool ShaperComponent::add(Packet *pkt) 
{
  timeval now, pkt_now;
  pkt_now = pkt->timeStamp;
  gettimeofday(&now, NULL);

  if (first.tv_sec > 0) {
    long elapsed = (now.tv_sec - first.tv_sec) * 1000000
      + (now.tv_usec - first.tv_usec);

    long target = (pkt_now.tv_sec - pkt_first.tv_sec) * 1000000
      + (pkt_now.tv_usec - pkt_first.tv_usec);

    long sleeping = /*(long)((float)*/ (target/factor) - elapsed;
    if (sleeping > 0) usleep(sleeping);
  } else {
    if (factor == 0) factor = 1;
    pkt_first = pkt_now;
    first = now;
  }

  push(pkt);

  return false;
}

void ShaperComponent::cleanup(void)
{
  first.tv_sec = 0;  
} 
