/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <libpandora/global.h>

extern "C" {
#include <stdlib.h>  
#include <assert.h>
#include <libpandora/conf/unistd.h>
	   }

#include "siblingmatchcomponent.h"
#include <pandora_components/cachetranspacket.h>
#include <pandora_components/httptranspacket.h>
#include <pandora_components/httppacket.h>
#include <pandora_components/tcppacket.h>
#include <pandora_components/ippacket.h>

component_export(SiblingMatchComponent, CacheTransPacket, CacheTransPacket);

bool SiblingMatchComponent::add(Packet* obj)
{
  CacheTransPacket *ctpp = (CacheTransPacket *)obj;
  
  int smindex= (int) (ctpp->type == CacheTransPacket::hit_sibling);
  SMList *list0=&smlist[1-smindex];
  SMList *list1=&smlist[smindex];

  bool found = false;

  if (!list1->empty()) {
    switch (ctpp->type) {
    case CacheTransPacket::hit_sibling:
      found = findMatch(ctpp, list1, true); break;	

    case CacheTransPacket::hit_ok: case CacheTransPacket::hit_bad:
      found = findMatch(ctpp, list1, false); break;

    default: break;
    }
  }
  if (!found) {
    list0->push_back(ctpp);
  }
  
  //if (list0->empty() && list1->empty()) return true;
  //else return false;
  return false;
}

bool SiblingMatchComponent::findMatch(CacheTransPacket *ctpp, 
				      SMList *list, bool sib)
{
  SMListIter ptr;
  CacheTransPacket *sibling = NULL, *hit = NULL;

  if (sib) sibling = ctpp;
  else hit = ctpp;
  
  for (ptr = list->begin(); ptr != list->end(); ++ptr) {
    CacheTransPacket *ctpp1 = *ptr;
    pandora_assert(ctpp1 != NULL);
    if (sib) hit = ctpp1;
    else sibling = ctpp1;

    locatePacket(IPPacket, hitip, hit);
    locatePacket(IPPacket, sibip, sibling);

    if (sibling->proxy.s_addr == hitip->src.s_addr
	&& hit->proxy.s_addr == sibip->dst.s_addr) {
      dispatch(sibling, hit);
      list->erase(ptr);
      return true;
    }
  }
  return false;
}

void SiblingMatchComponent::dispatch(CacheTransPacket *sibling,
				     CacheTransPacket *hit)
{
  locatePacket(HTTPTransPacket,	hitht, 	hit);
  locatePacket(HTTPPacket, 	hith, 	hitht);
  locatePacket(TCPPacket, 	hittcp, hith);
  locatePacket(IPPacket, 	hitip, 	hittcp);
  locatePacket(HTTPTransPacket, sibht, 	sibling);
  locatePacket(TCPPacket, 	sibtcp, sibht);
  locatePacket(IPPacket, 	sibip, 	sibtcp);

  sibip->dst.s_addr = 	hitip->dst.s_addr;
  sibtcp->dport = 	hittcp->dport;
  
  sibht->rtt =		hitht->rtt;
  sibht->lat = 		hitht->lat;
  sibht->resphlen = 	hitht->resphlen;
  sibht->respmlen =  	hitht->respmlen;
  sibht->reqhlen =  	hitht->reqhlen;
  sibht->reqmlen =  	hitht->reqmlen;
    
  sibling->p_dport = 	hittcp->dport;
  sibling->rtt_saved = 	hitht->rtt - sibht->rtt;
  sibling->lat_saved = 	hitht->lat - sibht->lat;
  
  sibling->bytes_saved= hit->bytes_saved;

  sibling->bytes_sibling = (hitht->reqhlen + hitht->reqmlen
			 + hitht->resphlen + hitht->respmlen);

  sibling->p_ims = hith->ims;
  sibling->p_ius = hith->ius;
  sibling->p_lm = hith->lm;
  sibling->p_expires = hith->expires;
  sibling->type = CacheTransPacket::hit_sibling;

  cleanPacket(hit);
  push(sibling);
}

void SiblingMatchComponent::cleanup(void)
{
  flush(&smlist[0]);
  flush(&smlist[1]);
}

void SiblingMatchComponent::flush(SMList *l)
{
  if (!l->empty()) {
    SMListIter ptr;
    for (ptr=l->begin(); ptr!=l->end(); ++ptr) {
      CacheTransPacket *ctpp = *ptr;
      push(ctpp);
    }
  }
  l->clear();
} 

