/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef SIBLING_MATCH_COMPONENT_H
#define SIBLING_MATCH_COMPONENT_H

#include <libpandora/global.h>

#include <list>
#include <pandora_components/cachetranspacket.h>
#include <libpandora/component.h>

class SiblingMatchComponent : public Component {
private:
  typedef list<CacheTransPacket*> SMList;
  typedef SMList::iterator SMListIter;
  SMList smlist[2];
  
public:
  component_init(SiblingMatchComponent, 1);
  SiblingMatchComponent(void) {}
  virtual ~SiblingMatchComponent(void) {}

  bool add(Packet*);
  void cleanup(void);
  void dispatch(CacheTransPacket *, CacheTransPacket *);
  
private:
  bool findMatch(CacheTransPacket *, SMList *, bool);
  void flush(SMList *);
};

#endif /* SIBLING_MATCH_COMPONENT_H */
