/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#ifndef SYSTRACE_H
#define SYSTRACE_H

#ifdef __KERNEL__
#define u_int32_t u32
#else
#include <sys/ioctl.h>
#include <sys/time.h>

#ifdef linux
#include <stdint.h>
#else
#ifndef u_int32_t
#define u_int32_t unsigned int
#endif
#endif

#endif

#define IOC_FILTER	_IOW('&', 0, struct syscall_filter)
#define IOC_SCSTATS	_IOR('&', 1, struct systrace_stats)
#define IOC_HDRST	_IO('&', 2)

struct systrace_stats {
  unsigned int	total, drops, errors;
};

struct syscall_arg {
#define SYSCALL_ARG_INT		1
#define SYSCALL_ARG_STR		2
  int 	type;
  int 	i;
  char *p;
};

struct syscall_task {
  u_int32_t	pid;
  u_int32_t	uid;
  char		comm[16];
  char		cwd[256];
};

struct syscall_hdr {
  struct timeval 	stamp;
  u_int32_t		type;
  u_int32_t		len;
  int	   		ret;
  int			nargs;
  struct syscall_task	task;
};

#define SYSCALL_FILTER_PID	(1 << 0)
#define SYSCALL_FILTER_UID	(1 << 1)
#define SYSCALL_FILTER_COMM	(1 << 2)
#define SYSCALL_FILTER_CWD	(1 << 3)

struct syscall_filter {
  struct syscall_task	task;
  u_int32_t		mask;
  int			truth;
};

#endif /* SYSTRACE_H */
