/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef SYSTRACE_COMPONENT_H
#define SYSTRACE_COMPONENT_H

#include <libpandora/global.h>

#include <libpandora/inputcomponent.h>
#include <pandora_components/syscallpacket.h>

class SystraceComponent : public InputComponent {
private:
  char *device;
  int fd;
  bool kernel;
  char buf[BUFSIZ];

public:

  component_init(SystraceComponent, 1);
  inline SystraceComponent(void);
  virtual ~SystraceComponent(void) { }
  virtual int  init(void);
  virtual bool process(void);
  virtual void finish(void);
};

SystraceComponent::SystraceComponent(void) 
  : device(NULL), fd(-1), kernel(false) 
{ 
  registerOption("device", &device);
  registerOption("kernel", &kernel);
}
#endif /* SYSTRACE_COMPONENT_H */
