/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef TCP_PACKET_H
#define TCP_PACKET_H

#include <libpandora/global.h>

extern "C" {
#include <pandora_components/tcp.h>
	   }

#include <libpandora/packet.h>

class IPPacket;


class TCPPacket : public Packet {
public:
  u_short  	sport;
  u_short  	dport;

  u_short 	length;
  u_char  	flags;
  u_int32_t  	seq;
  u_int32_t  	ack;
  u_short  	cksum;
  bool  	gap;
  bool  	eof;

  bool  	hint;

public:
  packet_init(TCPPacket, 1);

  TCPPacket(IPPacket *);
  TCPPacket(const TCPPacket& x);
  TCPPacket& operator= (const TCPPacket& x);
  virtual ~TCPPacket(void) { }

  virtual void print(ostream *) ;

  virtual size_t write(char *, size_t, int) ;
  virtual size_t read(const char *, int);

  inline bool reject(void) const;
};

bool TCPPacket::reject(void) const
{
  return (length == 0) && !(flags & (TH_SYN|TH_RST|TH_FIN));
}

#endif /* TCP_PACKET_H */
