/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef TCP_REORDER_COMPONENT_H
#define TCP_REORDER_COMPONENT_H

#include <libpandora/global.h>

extern "C" {
#include <libpandora/conf/time.h>
}

#include <list>

#include <libpandora/component.h>

class TCPPacket;
/*
 * TCP sequence numbers are 32 bit integers operated
 * on with modular arithmetic.  These macros can be
 * used to compare such integers.
 */
#ifndef SEQ_LT
#define SEQ_LT(a, b)    ((int32_t)((a)-(b)) < 0)
#define SEQ_LEQ(a, b)   ((int32_t)((a)-(b)) <= 0)
#define SEQ_GT(a, b)    ((int32_t)((a)-(b)) > 0)
#define SEQ_GEQ(a, b)   ((int32_t)((a)-(b)) >= 0)
#endif

/** TCP reordering component class.
    This component is used to reorder TCP packets belonging to the same 
    connection (same source and destination IP address and port).
 */
class TCPReorderComponent : public Component {
private:
  typedef list<TCPPacket*> PList;
  typedef PList::iterator PListIter;


private:
  u_int32_t nextSeq;
  int bytesStored;
  int bytesMax, packetsMax;
  enum { TCPS_LISTEN = 1, TCPS_ESTABLISHED } state;
  bool force;
  bool eof;
  PList plist;


public:

  component_init(TCPReorderComponent, 1);
  TCPReorderComponent(void) : 
    nextSeq(0), bytesStored(0), bytesMax(146000), packetsMax(10),
    state(TCPS_LISTEN), force(false), eof(false) { 
    registerOption("bytes", &bytesMax);
    registerOption("packets", &packetsMax);
  }
  virtual ~TCPReorderComponent(void) { }


  virtual bool add(Packet *);
  virtual void cleanup(void);

protected:
  bool dispatch(void);  
  void flush(void);
};


#endif /* TCP_REORDER_COMPONENT_H */
