/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef TCP_REQ_FLOW_COMPONENT_H
#define TCP_REQ_FLOW_COMPONENT_H

#include <libpandora/global.h>

#include <libpandora/component.h>

class UDPPacket;

class TCPReqFlowComponent : public Component {
private:
  u_int32_t finSeq;
  u_short toRead;
  bool synch, started, done;
  UDPPacket *udpp;

public:  
  int snapLen;

public:

  component_init(TCPReqFlowComponent, 1);
  TCPReqFlowComponent(void) : finSeq(0), toRead(0),
    synch(false), started(false), done(false),
    udpp(NULL), snapLen(0) {
    registerOption("snaplen", &snapLen);
  }

  virtual ~TCPReqFlowComponent(void) { }

  virtual bool add(Packet *p);
  virtual void cleanup(void);

  inline void dispatch(void);
};

void TCPReqFlowComponent::dispatch(void) 
{
  if (udpp != NULL) {
    push((Packet *)udpp);
    udpp = NULL;
    synch = started = done = false;
  }    
}


#endif /* TCP_REQ_FLOW_COMPONENT_H */
