/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <libpandora/global.h>

extern "C" {
#include <stdlib.h>
	   }

#include "tcpsourcecomponent.h"
#include <pandora_components/tcppacket.h>
#include <pandora_components/ippacket.h>

component_export(TCPSourceComponent,, TCPPacket);

int TCPSourceComponent::init(void) 
{
  srand(time(NULL));
  return VOID_FILENO;
}

bool TCPSourceComponent::process(void) 
{
  static char payload[128];

  IPPacket *ipp = new IPPacket(0);
  ipp->setTimeStamp();
  ipp->src.s_addr = 	rand();
  ipp->dst.s_addr = 	rand();
  ipp->length =		128+((u_int)rand())%1372;
  (ipp->_data).setNoCopy(payload, sizeof(payload));

  TCPPacket *tcpp = new TCPPacket(ipp);
  tcpp->sport = 	(rand() >> 17) + 1;
  tcpp->dport = 	(rand() >> 17) + 1;
  tcpp->length =	ipp->length - 40;
  push(tcpp);

  return false;
}
