/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <libpandora/global.h>

#include "testcomponents.h"
#include <pandora_components/udppacket.h>
#include <pandora_components/tcppacket.h>
#include <libpandora/stackdesc.h>
#include <libpandora/sched_task.h>
#include <libpandora/timersupervisor.h>
#include <libpandora/sched_manager.h>

component_export(TestComponent, Packet, Packet);

static void expf(void *data, time_t t)
{
  pandora_info("expired @" << t);
}

static void remf(void *data, time_t t)
{
  pandora_info("removed @" << t);
}

TestComponent::TestComponent(void)
  : smgr(NULL)
{
}

TestComponent::~TestComponent(void) 
{
  __DELETE(smgr);
}

static int n = 0;
static sched_handle_t h = 0;

void TestComponent::setup(void) 
{
  pandora_debug("setup");
  pandora_assert(timerSupervisor != NULL);
  smgr = new sched_manager_t(timerSupervisor->getScheduler());
  h = smgr->schedule(sched_task_t(&expf, &remf, NULL), 5, false);
}

void TestComponent::cleanup(void) 
{
  if (smgr != NULL) smgr->cleanup();
}

bool TestComponent::add(Packet *pkt) 
{
  if (++n == 3) {
    smgr->reschedule(h, 1, true);
  }
  push(pkt);
  return false;
}
