/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <libpandora/global.h>

extern "C" {
#include <stdlib.h>
	   }

#include "valsourcecomponent.h"
#include <pandora_components/valuepacket.h>

component_export(ValSourceComponent,, FloatValuePacket|IntValuePacket|TextValuePacket|BoolValuePacket);

int ValSourceComponent::init(void) 
{
  srand(time(NULL));
  return VOID_FILENO;
}

bool ValSourceComponent::process(void) 
{
  Packet *vp = NULL;

  switch((MultiValue::multi_value_t) type) {
  case MultiValue::integer:
    vp = new IntValuePacket(doRand ? rand() : 23);
    break;
  case MultiValue::boolean:
    vp = new BoolValuePacket((bool)(rand() & 1));
    break;
  case MultiValue::floating:
    vp = new FloatValuePacket((float)(rand() % 1000) 
			      + (float)(rand() % 1000)/1000);
    break;
  case MultiValue::textual:
    vp = new TextValuePacket(str);
    break;
  default:
    pandora_warning("invalid type: " << type);
    break;
  }

  if (vp == NULL) return true;

  push(vp);

  return false;
}
