/* Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include <libpandora/global.h>

extern "C" {
#include <sys/socket.h>
}

#include "w2nfiltercomponent.h"
#include <pandora_components/fseventpacket.h>
#include <pandora_components/w2npacket.h>
#include <pandora_components/requestpacket.h>
#include <libpandora/stackdesc.h>
#include <libpandora/netutil.h>
#include <libpandora/timeval.h>

component_export(W2NFilterComponent, W2NPacket+|FSEventPacket+, W2NPacket);

exportHandler(W2NFilterComponent, FSEventPacket);
exportHandler(W2NFilterComponent, W2NPacket);

W2NFilterComponent::W2NFilterComponent(void)
{
  registerHandler(W2NFilterComponent, FSEventPacket);
  registerHandler(W2NFilterComponent, W2NPacket);
}

bool W2NFilterComponent::add(FSEventPacket *fsep)
{
  if (!(fsep->path).isNull()) {
    text url = fsep->path;
    match(fsep, url);

#if 1
    int minlen = 0;
    const char *data =  url.data();

    char *ptr = strstr(data, "//");
    if (ptr != NULL) minlen = ptr - data + 2;
 
    for(int len = url.length();	len > minlen; --len) {
      if (data[len - 1] == '/') 
	match(fsep, text(data, len));
    }
#endif
  }
  cleanPacket(fsep);
  return false;
}

bool W2NFilterComponent::add(W2NPacket *w2np)
{
  if ((w2np->url).isNull()) {
    cleanPacket(w2np);
    return false;
  }

  if (!(w2np->url).isNull()) (w2np->url).update();
 
 if (w2np->getOpCode() == W2NPacket::UNSUBSCRIBE) {
    if (!(w2np->url).isNull()) {
      W2NPacket *pkt = notifications.removeKey(w2np->url);
      cleanPacket(pkt);
    }
    cleanPacket(w2np);
    return false;
  }

  if (w2np->getOpCode() == W2NPacket::SUBSCRIBE) {
    W2NPacket *p = notifications.atOrNil(w2np->url);
    if (p != NULL) {
      notifications.removeKey(p->url);
      cleanPacket(p);
    }
    notifications.atPut(w2np->url, w2np);
    //pandora_debug("adding subscription for: '" << w2np->url << "'");
  }

  return false;
}

void W2NFilterComponent::cleanup(void)
{
  //timeval ts1, ts2;
  //gettimeofday(&ts1, NULL);
#if 0
  while (notifications.size() > 0) {
    W2NPacket *w2np;
    valuesDo(notifications, w2np) {
      notifications.removeKey(w2np->url);
      cleanPacket(w2np);
    }
  }
#else
  W2NPacket *w2np;
  valuesDo(notifications, w2np) cleanPacket(w2np);
  notifications.clear();
#endif
  //gettimeofday(&ts2, NULL);
  //pandora_debug("cleanup time: " << (ts2 - ts1) << "s");
}

static void dump_notif(Map<text, W2NPacket *> *n, const text &u)
{
  text url;
  W2NPacket *w2np;

  keysValuesDo(*n, url, w2np) {
    pandora_debug("'" << url << "' [" << url.length() 
		 << "/" << strlen(url.data()) << "] -> " << *w2np);
    if (u == url) pandora_error("this should have matched");
  }
}

bool W2NFilterComponent::match(const FSEventPacket *fsep, const text &url)
{
  W2NPacket *w2np = notifications.atOrNil(url) ;

  if (w2np != NULL) {
#if 0
    pandora_debug(url << ": match    (" << notifications.size() << ")");
#endif
    W2NPacket *wp = new W2NPacket(*w2np);
    wp->setOpCode(fsep);
    wp->timeStamp = fsep->timeStamp;
    push(wp);
    return true;
  } else {
#if 0
    pandora_debug("'" << url << "' [" << url.len << "] : no match (" 
		 << notifications.size() << ")");
#endif
    //dump_notif(&notifications, url);
    return false;
  }
}

