/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef W2N_PACKET_H
#define W2N_PACKET_H

#include <libpandora/global.h>

extern "C" {
#include <netinet/in.h>
}

#include <libpandora/packet.h>
#include <libpandora/text.h>


class FSEventPacket;
class TextValuePacket;

class W2NPacket : public Packet {
public:
  enum w2nt_t { 
    ERROR = -1, SUCCESS = 0,
    NOTIF = 1, UPDATE = NOTIF, UNLINK, MKDIR, RMDIR, RENAME,
    TO_PARENT_REQ = 6, SERVCE_PORT = TO_PARENT_REQ, SUBSCRIBE,
    UNSUBSCRIBE, LIST,
    TO_BS_REQ = 10, CLIENT_BIND = TO_BS_REQ, NS_REGISTER, NS_BIND,
    MONITOR_REGISTER, NS_UNREGISTER, MONITOR_UNREGISTER
  };

public:
  short		opcode;
  int		version;
  in_addr_t	addr;
  int		port;
  int		asnum;
  text		url;
  text		url2;
  text		server;

  text		path;
  text		path2;  

public:
  packet_init(W2NPacket, 1);

public:
  W2NPacket(int);
  W2NPacket(TextValuePacket *vp);
  W2NPacket(const W2NPacket& x);
  W2NPacket& operator= (const W2NPacket& x);
  virtual ~W2NPacket(void) { }

  virtual void print(ostream *f) ;

  virtual size_t write(char *, size_t, int) ;
  virtual size_t read(const char *, int);

  void setOpCode(w2nt_t op) { opcode = (short) op; }
  void setOpCode(const FSEventPacket *);
  w2nt_t getOpCode(void) { return (w2nt_t) opcode; }

  static W2NPacket *recv_raw(int fd, char *temp, size_t maxlen);
};

#endif /* W2N_PACKET_H */
