/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef WALL_CLOCK_COMPONENT_H
#define WALL_CLOCK_COMPONENT_H

#include <libpandora/global.h>

extern "C" {
#include <libpandora/conf/time.h>
	   }

#include <libpandora/packet.h>
#include <libpandora/inputcomponent.h>
#include <libpandora/common_options.h>

class WallClockComponent : public InputComponent {
private:
  bool _quit;
  timeval tv;
  Component *nextStack;
  TimerSupervisor *timer;
  int freq;
  
public:

  component_init(WallClockComponent, 1);
  WallClockComponent(void) : nextStack(NULL), timer(NULL), freq(1) {
    registerOption("freq", &freq);
    registerComplexOption(running_stack_option, "stack", &nextStack);

    tv.tv_sec = (time_t) 0;
    tv.tv_usec = 0;
  }
  virtual ~WallClockComponent(void) {}

  virtual int  init(void);
  virtual bool process(void);
  virtual void finish(void) { }

  void cleanup(void);
};

#endif /* WALL_CLOCK_COMPONENT_H */
