/* Copyright (C) 1999, 2000, 2001, 2002 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#include <libpandora/global.h>

#include "windowercomponent.h" 
#include <pandora_components/valuepacket.h> 

component_export(WindowerComponent, IntValuePacket+, IntValuePacket);


WindowerComponent::WindowerComponent(void)
  : val(0), size(0)
{ 
  registerOption("size",     &size); 
}

bool WindowerComponent::add(Packet *pkt) 
{
  locatePacket0(IntValuePacket, vp, pkt);

  if (vp == NULL) return_clean(pkt);

  IntValuePacket *vp2 = update(vp);
  
  cleanPacket(vp2);
  return false;
} 

IntValuePacket *WindowerComponent::update(IntValuePacket *vp)
{
  if (vp == NULL) return NULL;

  Q.add(vp);
  val += vp->val;

  IntValuePacket *vp2 = NULL;
  if (Q.size() > size) {
    vp2 = Q.remove();
    val -= vp2->val;
  }

  dispatch();

  return vp2;
}

void WindowerComponent::dispatch(void)
{
  if (Q.size() == size) 
    push(new IntValuePacket((val/size), (Q.last())->timeStamp));
}

void WindowerComponent::cleanup(void) 
{ 
  while (!Q.isEmpty()) {
    IntValuePacket *vp = Q.remove();
    cleanPacket(vp);
  }
}


