/* ---*-C++-*---------------------------------------------------------------
Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA

This file is part of Pandora, the Flexible Monitoring Platform.

Pandora is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

Pandora is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pandora; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */


#ifndef WRITER_COMPONENT_H
#define WRITER_COMPONENT_H

#include <libpandora/global.h>

extern "C" {
#include <stdio.h>
#include <limits.h>
}

#include <libpandora/outputcomponent.h>
#include <libpandora/packet.h>
#include <libpandora/pandora_limits.h>

class WriterComponent : public OutputComponent {
private:
  FILE *f;
  char buf[MAX_PACKET_SIZE];
  char *prefix;
  int fsize;
  int tinter;
  int offset;

  int sizeCount;
  int timeCount;
  time_t lastPktTime;
  
public:

  component_init(WriterComponent, 1);
  WriterComponent(void);
  virtual ~WriterComponent(void) { }

  virtual bool add(Packet *);
  virtual void setup(void) ;
  virtual void cleanup(void) ;

private:
  void updateLimits(time_t, int);
};

#endif /* WRITER_COMPONENT_H */
