# Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA
#
# This file is part of Pandora, the Flexible Monitoring Platform.
#
# Pandora is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# Pandora is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Pandora; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

if ($0 =~ /(.*)\/.*/) {
    $dir = $1;
} else {
    $dir = ".";
}


sub from_libconfig($) {
    my $d = shift(@_);
    my ($line, $comp, %libs, %libs_used) ;
    
    my $pandora="$d/pandora";

    open(LIBCONFIG, "$d/libconfig") 
	or die "$0: need libconfig, try make $d/libconfig";

    while ($line = <LIBCONFIG>) {
	if ($line =~ /^\[component\]\s+(\w+)\s+(\w+)/) {
	    $libs{$1} = "$2.la";
	}
    }
    
    close(LIBCONFIG);
    
    foreach $stack (@ARGV) {
	open(STACK, "$pandora -dd $stack|") 
	    or print STDERR "$0: $stack: cannot load stack definition\n";
	
	while ($line = <STACK>) {
	    foreach $comp (grep(/\@/, split (/\s+/, $line))) {
		if ($comp =~ /\@(.*)\:/) {
		    $libs_used{ $libs{$1} } = 1;
		}
	    }
	}
	close(STACK);
    }
    return (keys %libs_used);
}

@l = from_libconfig($dir);
print "@l\n";
